﻿using System;
using System.Data;
using System.Data.SqlClient;

public class PatientImageDetail
{
    public int Id { get; set; }
    public int PatientId { get; set; }
    public int? ImageFragmentCountId { get; set; }
    public int? ImageTypeId { get; set; }

    public DateTime DateImaged { get; set; }

    public bool? FragmentVerfied { get; set; }
    public bool? SystemIdentified { get; set; }
    public bool? Reviewed { get; set; }
    public bool? IncludeInReport { get; set; }
    
    
    public string LargestFragmentSize { get; set; }
    public string SmallestFragmentSize { get; set; }
    public string StudyId { get; set; }
    public string StudyDescription { get; set; }
    public string ImageUrl { get; set; }
    public string Comments { get; set; }
    public string ImageReasonOtherText { get; set; }
    public string ImageTypeOtherText { get; set; }

    public PatientImageDetail(DataRow dr)
    {
        Id = dr.Field<int>("PATIENT_IMAGE_ID");
        PatientId = dr.Field<int>("PATIENT_ID");
        ImageFragmentCountId = dr.Field<int?>("STD_IMAGE_FRAGMENT_COUNT_ID");
        ImageTypeId = dr.Field<int?>("STD_IMAGE_TYPE_ID");

        DateImaged = dr.Field<DateTime>("DATE_IMAGED");

        FragmentVerfied = dr.Field<bool?>("FRAGMENT_VERIFIED_FLAG");
        SystemIdentified = dr.Field<bool?>("SYSTEM_IDENTIFIED_FRAGMENT_FLAG");
        Reviewed = dr.Field<bool?>("REVIEWED_FLAG");
        IncludeInReport = dr.Field<bool?>("INCLUDE_IN_REPORT_FLAG");

        LargestFragmentSize = dr.Field<string>("LARGEST_FRAGMENT_SIZE");
        SmallestFragmentSize = dr.Field<string>("SMALLEST_FRAGMENT_SIZE");
        StudyId = dr.Field<string>("STUDY_ID");
        StudyDescription = dr.Field<string>("STUDY_DESCRIPTION");
        ImageUrl = dr.Field<string>("IMAGE_URL");
        Comments = dr.Field<string>("COMMENTS");
        ImageReasonOtherText = dr.Field<string>("IMAGE_REASON_OTHER_TEXT");
        ImageTypeOtherText = dr.Field<string>("IMAGE_TYPE_OTHER_TEXT");
    }

    public PatientImageDetail(object[] parameters)
    {
        Id = Convert.ToInt32(parameters[0]);
        ImageFragmentCountId = parameters[6] != null ? Convert.ToInt32(parameters[6]) : (int?)null;
        ImageTypeId = parameters[7] != null ? Convert.ToInt32(parameters[7]) : (int?)null;

        FragmentVerfied = parameters[1] != null ? Convert.ToBoolean(parameters[1]) : (bool?)null;
        Reviewed = parameters[2] != null ? Convert.ToBoolean(parameters[2]) : (bool?)null;
        IncludeInReport = parameters[3] != null ? Convert.ToBoolean(parameters[3]) : (bool?)null;

        Comments = parameters[8] != null ? Convert.ToString(parameters[8]) : null;

        SmallestFragmentSize = parameters[4] != null ? Convert.ToString(parameters[4]) : null;
        LargestFragmentSize = parameters[5] != null ? Convert.ToString(parameters[5]) : null;
        ImageReasonOtherText = parameters[9] != null ? Convert.ToString(parameters[9]) : null;
        ImageTypeOtherText = parameters[10] != null ? Convert.ToString(parameters[10]) : null;
    }
}